
using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.DBD
{
    internal class EvaluationSheet : PI.FM.N000.Base.BL.DBD.BaseTable<BO.EvaluationSheet>
    {
        #region Static factory
        private static EvaluationSheet _factory = null;

        public static EvaluationSheet DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new EvaluationSheet();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_EvaluationSheet";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Name", "Name",true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Abbreviation", "Abbreviation", true));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("Salary", "Salary", true));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("From", "From"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("To", "To"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Weight", "Weight"));
        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.CompetencePart>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.CompetencePart.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("Weight", Gemini.Core.BL.DAL.SqlTypes.Int));
                Add(new Gemini.Core.BL.DBD.Param("PointPercent", Gemini.Core.BL.DAL.SqlTypes.Int));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_EvaluationSheet_RestoreBySearch";
            }
        }
        #endregion
    }
}
